/******************************************************************************
 **  Copyright (c) 2007-2014, Calaos. All Rights Reserved.
 **
 **  This file is part of Calaos.
 **
 **  Calaos is free software; you can redistribute it and/or modify
 **  it under the terms of the GNU General Public License as published by
 **  the Free Software Foundation; either version 3 of the License, or
 **  (at your option) any later version.
 **
 **  Calaos is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **
 **  You should have received a copy of the GNU General Public License
 **  along with Foobar; if not, write to the Free Software
 **  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 **
 ******************************************************************************/
#ifndef S_OWTemp_H
#define S_OWTemp_H

#include <InputTemp.h>
#include <EcoreTimer.h>

using namespace Calaos;

class OWTemp;

struct OWData
{
    OWTemp *owTemp;
    bool ret;
    string result;
};

class OWTemp : public InputTemp
{
private:
    char retry;
    EcoreTimer *retry_timer;

protected:
    std::string ow_id;
    std::string ow_args;
    bool start;

    friend void *_ow_thread_callback(void *data);
    void readValue_cb(bool ret, string res);
    virtual void readValue();
    void readValueReal();

public:
    OWTemp(Params &p);
    ~OWTemp();
};

#endif
