/******************************************************************************
 **  Copyright (c) 2006-2014, Calaos. All Rights Reserved.
 **
 **  This file is part of Calaos.
 **
 **  Calaos is free software; you can redistribute it and/or modify
 **  it under the terms of the GNU General Public License as published by
 **  the Free Software Foundation; either version 3 of the License, or
 **  (at your option) any later version.
 **
 **  Calaos is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **
 **  You should have received a copy of the GNU General Public License
 **  along with Foobar; if not, write to the Free Software
 **  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 **
 ******************************************************************************/
#include <OWCtrl.h>

#ifdef HAVE_OWCAPI_H
#include <owcapi.h>
#endif


using namespace Calaos;

Owctrl::Owctrl(string args)
{
#ifdef HAVE_OWCAPI_H
    if (OW_init(args.c_str()) != 0)
    {
	cErrorDom("input") << "Unable to initialize OW library : " << strerror(errno);
    }
    else
    {
	cInfoDom("input") << "OW Library initialization ok";
    }
#endif
}


Owctrl::~Owctrl()
{
#ifdef HAVE_OWCAPI_H
    cInfoDom("input") << "OW Library uninitialization";
    OW_finish();
#endif
}

bool Owctrl::getValue(string path, string &value)
{
#ifdef HAVE_OWCAPI_H
    char *res;
    size_t len;

    if (OW_get(path.c_str(), &res, &len) >= 0)
    {
	value = res;
        free(res);
	return true;
    }
    else
    {
	return false;
    }
#else
    cInfoDom("input") << "One Wire support not enabled !";
#endif
    return false;
}

Owctrl &Owctrl::Instance(string args)
{
    static Owctrl inst(args);
    return inst;
}
