/******************************************************************************
 **  Copyright (c) 2007-2014, Calaos. All Rights Reserved.
 **
 **  This file is part of Calaos.
 **
 **  Calaos is free software; you can redistribute it and/or modify
 **  it under the terms of the GNU General Public License as published by
 **  the Free Software Foundation; either version 3 of the License, or
 **  (at your option) any later version.
 **
 **  Calaos is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **
 **  You should have received a copy of the GNU General Public License
 **  along with Foobar; if not, write to the Free Software
 **  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 **
 ******************************************************************************/
#ifndef AVRPIONEER_H
#define AVRPIONEER_H

#include <Calaos.h>
#include <AVReceiver.h>

namespace Calaos
{

//Manage Pioneer device
class AVRPioneer: public AVReceiver
{
protected:

    void decodeDisplayText(string &text);

    virtual void processMessage(string msg);
    virtual void connectionEstablished();

public:
    AVRPioneer(Params &p);
    virtual ~AVRPioneer();

    virtual void Power(bool on, int zone = 1);
    virtual void setVolume(int volume, int zone = 1);
    virtual void selectInputSource(int source, int zone = 1);
    virtual bool hasDisplay() { return true; } //Pioneer has display infos through ethernet
};

}

#endif // AVRPIONEER_H
